// DlgParams.cpp : implementation file
//

#include "stdafx.h"
#include "MBACloudMarble.h"
#include "DlgParams.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgParams dialog


CDlgParams::CDlgParams(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgParams::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgParams)
	m_Size		= 0.0f;
	m_Octaves	= 4.0f;
	m_warping	= 0.0f;
	m_veinMult	= 1.0f;
	m_base1Mult	= 1.0f;
	m_base2Mult	= 1.0f;
	m_veinamount= 0.0f;
	m_veinpower = 0;
	//}}AFX_DATA_INIT
}


void CDlgParams::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgParams)
	DDX_Control(pDX, IDC_B_1STBASECOLOR, m_btnBaseColor1);
	DDX_Control(pDX, IDC_B_2NDBASECOLOR, m_btnBaseColor2);
	DDX_Control(pDX, IDC_B_EVENCOLOR, m_btnEvenColor);
	DDX_Text(pDX, IDC_E_SIZE, m_Size);
	DDX_Text(pDX, IDC_E_OCTAVES, m_Octaves);
	DDX_Text(pDX, IDC_E_WARPING, m_warping);
	DDX_Text(pDX, IDC_E_VEIN_MULT,  m_veinMult);
	DDX_Text(pDX, IDC_E_BASE1_MULT, m_base1Mult);
	DDX_Text(pDX, IDC_E_BASE2_MULT, m_base2Mult);
	DDX_Text(pDX, IDC_E_VEINAMOUNT, m_veinamount);
		DDV_MinMaxFloat(pDX, m_veinamount, 0.0f, 100.0f);
	DDX_Text(pDX, IDC_E_VEINPOWER, m_veinpower);
		DDV_MinMaxInt(pDX, m_veinpower, 1, 8);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgParams, CDialog)
	//{{AFX_MSG_MAP(CDlgParams)
	ON_BN_CLICKED(IDC_B_EVENCOLOR, OnEvenColor)
	ON_BN_CLICKED(IDC_B_1STBASECOLOR, OnBaseColor1)
	ON_BN_CLICKED(IDC_B_2NDBASECOLOR, OnBaseColor2)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_B_APPLY, OnApply)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgParams message handlers


void CDlgParams::OnEvenColor() 
{
	CColorDialog dlg(GetEvenColor(), 0, this);
	dlg.DoModal();
	m_btnEvenColor.SetColor(dlg.GetColor());
	m_btnEvenColor.RedrawWindow();
}

void CDlgParams::OnBaseColor1() 
{
	CColorDialog dlg(GetBaseColor1(), 0, this);
	dlg.DoModal();
	m_btnBaseColor1.SetColor(dlg.GetColor());
	m_btnBaseColor1.RedrawWindow();
}

void CDlgParams::OnBaseColor2() 
{
	CColorDialog dlg(GetBaseColor2(), 0, this);
	dlg.DoModal();
	m_btnBaseColor2.SetColor(dlg.GetColor());
	m_btnBaseColor2.RedrawWindow();
}

BOOL CDlgParams::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_btnEvenColor.SetColor(GetEvenColor());
	m_btnBaseColor1.SetColor(GetBaseColor1());
	m_btnBaseColor2.SetColor(GetBaseColor2());
	m_Size		= size;
	m_Octaves	= octaves;
	m_warping	= warping;
	m_veinMult	= veinMult;
	m_base1Mult	= base1Mult;
	m_base2Mult	= base2Mult;
	m_veinamount= veinAmount;
	m_veinpower	= (int)veinPower;
	UpdateData(FALSE);
	return TRUE;
}

void CDlgParams::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete pDlgParam;
	pDlgParam = NULL;
}

void CDlgParams::OnApply() 
{
	UpdateData();
	SetEvenColor(m_btnEvenColor.GetColor());
	SetBaseColor1(m_btnBaseColor1.GetColor());
	SetBaseColor2(m_btnBaseColor2.GetColor());
	size		= m_Size;
	octaves		= m_Octaves;
	warping		= m_warping;
	veinAmount	= m_veinamount;
	veinPower	= (float)m_veinpower;
	veinMult	= m_veinMult;
	base1Mult	= m_base1Mult;
	base2Mult	= m_base2Mult;
	tsxShaderUpdate(ShaderID);			
}

