// CustomColor.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "MBACloudMarble.h"
#include "DlgParams.h"

/* disable annoying 'const double to float' truncation warning */
#pragma warning (disable:4305)
/* disable annoying 'double to float' truncation warning */
#pragma warning (disable:4244)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CCustomColorApp

BEGIN_MESSAGE_MAP(CCustomColorApp, CWinApp)
	//{{AFX_MSG_MAP(CCustomColorApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCustomColorApp construction

CCustomColorApp::CCustomColorApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCustomColorApp object

CCustomColorApp theApp;

#define NUM_PARAMS 11

int ShaderID;
char Name[] = "my_custom_color";
char* Params[NUM_PARAMS] = {	"vein color", "1st base", "2nd base", "VeinMult", "base1Mult", "Base2Mult", "size", "Octaves", "warping", "AmountVein", "PowerVein" };
tsxSHPARAM_TYPE Types[NUM_PARAMS] = {	tsxSHPARAM_COLOR, tsxSHPARAM_COLOR, tsxSHPARAM_COLOR, 
										tsxSHPARAM_FLOAT, tsxSHPARAM_FLOAT, tsxSHPARAM_FLOAT,
										tsxSHPARAM_FLOAT, tsxSHPARAM_FLOAT, tsxSHPARAM_FLOAT, 
										tsxSHPARAM_FLOAT, tsxSHPARAM_FLOAT };

tssColor vein_color		= { 1.00, 1.00, 1.00 };
tssColor base_color1	= { 0.89, 0.86, 0.83 };
tssColor base_color2	= { 0.35, 0.35, 0.40 };
float	veinMult	= 1.00;
float	base1Mult	= 1.00;
float	base2Mult	= 1.00;
float	size		= 1.00;
float	octaves		= 4.00;
float	warping		= 0.25;
float	veinAmount	= 1.00;
float	veinPower	= 3.00;

CDlgParams* pDlgParam = NULL;

void tsxShaderInitialize(tssData* data, int id)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	ShaderID = id;	// Store for later use

	data->nClass		= tsxSHCLASS_COLOR;
	data->sName			= Name;
	data->nDispNameID	= IDS_NAME;
	data->nHelpID		= IDS_HELP;
	data->nNumParam		= NUM_PARAMS;
	data->pParamName	= Params;
	data->pParamType	= Types;

	data->pfnShowInterface		= OnShowInterface;
	data->pfnGetParameterValue	= GetParameterValue;
	data->pfnSetParameterValue	= SetParameterValue;
	data->pfnExecute			= Execute;
}

void OnShowInterface(tssISTATE state)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	if(state == tssISTATE_STAY) return;

	if(state == tssISTATE_SHOW)
	{
		if(pDlgParam == NULL)
		{
			pDlgParam = new CDlgParams();
			pDlgParam->Create(IDD_PARAMS);
		}		

		pDlgParam->ShowWindow(SW_SHOW);
	}
	else
	{
		if(pDlgParam != NULL)
			pDlgParam->ShowWindow(SW_HIDE);
	}
}

void* GetParameterValue(char* name)
{
	switch(name[0])
	{
		case 'v':	return (void*)(&vein_color);
		case '1':	return (void*)(&base_color1);
		case '2':	return (void*)(&base_color2);
		case 's':	return (void*)(&size);
		case 'O':	return (void*)(&octaves);
		case 'w':	return (void*)(&warping);
		case 'V':	return (void*)(&veinMult);
		case 'b':	return (void*)(&base1Mult);
		case 'B':	return (void*)(&base2Mult);
		case 'A':	return (void*)(&veinAmount);
		case 'P':	return (void*)(&veinPower);
	}
	return NULL;
}

void SetParameterValue(char* name, void* value)
{
	switch(name[0])
	{
		case 'v':	
		{
			tssColor* pColor = (tssColor*)value;
			vein_color[0] = (*pColor)[0];
			vein_color[1] = (*pColor)[1];
			vein_color[2] = (*pColor)[2];
		}
		break;
		
		case '1':
		{
			tssColor* pColor = (tssColor*)value;
			base_color1[0] = (*pColor)[0];
			base_color1[1] = (*pColor)[1];
			base_color1[2] = (*pColor)[2];
		}
		break;
		case '2':
		{
			tssColor* pColor = (tssColor*)value;
			base_color2[0] = (*pColor)[0];
			base_color2[1] = (*pColor)[1];
			base_color2[2] = (*pColor)[2];
		}
		break;

		case 'V':	veinMult = *((float*)value);
		break;

		case 'b':	base1Mult = *((float*)value);
		break;

		case 'B':	base2Mult = *((float*)value);
		break;

		case 's':	size = *((float*)value);
		break;

		case 'O':	octaves = *((float*)value);
		break;

		case 'w':	warping = *((float*)value);
		break;

		case 'A':	veinAmount = *((float*)value);
		break;

		case 'P':	veinPower = *((float*)value);
		break;

	}
}

void Execute(tsxSHINFO* shinfo, tssSurface* surface, tssACTION action)
{
	switch(action)
	{
		case tssACTION_PREVIEW:
		case tssACTION_FULL:
		{
			if(shinfo != NULL)
			{
				for(int i = 0; i < NUM_PARAMS; i++)
				//for(int i = 0; i < 0; i++)
				{
					char name[64];
					tsxShaderInfoGetParameterName(shinfo, i, name);
					tsxSHPARAMVAL* pVal = tsxShaderInfoGetParameterValue(shinfo, i);
					
					switch(name[0])
					{
						case 'v':
						case '1':
						case '2':
						{
							tssColor c;
							tsxParameterValueGetTypedValue(pVal, tsxSHPARAM_COLOR, (void*)&c);
							SetParameterValue(name, (void*)&c);
						}
						break;

						case 'V':
						case 'b':
						case 'B':
						case 's':
						case 'O':
						case 'w':
						case 'A':
						case 'P':
						{
							float f;
							tsxParameterValueGetTypedValue(pVal, tsxSHPARAM_FLOAT, (void*)&f);
							SetParameterValue(name, (void*)&f);
						}
						break;
					}
				}
			}

			//---- init shader space
			float	frequency = size;
			tssPoint	PP;
			PP[0] =	surface->P[0]*frequency;
			PP[1] =	surface->P[1]*frequency;
			PP[2] =	surface->P[2]*frequency;

			//---- warp shader space 
			float	warp0;
			float	warp;

			warp0 = tssTurbulence3( PP, 3 );
			warp  = warp0*warping;
			PP[0] = PP[0]+warp;
			PP[1] =	PP[1]+warp;
			PP[2] = PP[2]+warp;

			//---- do custom noise
			int			i;
			float		sum		= 0.0;
			float		freq	= frequency;
			tssColor	result;
			tssPoint	PPfreq;

			float		noiseVal = tssNoise3(PP);

			for (i = 0; i < (int)octaves; i++)
			{
				PPfreq[0] = PP[0]*freq;
				PPfreq[1] = PP[1]*freq;
				PPfreq[2] = PP[2]*freq;

				sum = sum + 1.0f/freq*fabs(0.5-tssNoise3(PPfreq));
				freq *= 1.7321;
			}
			sum = 1-(frequency * sum * 2.0);
			sum = sum * veinAmount;
			if (sum < 0.0)
				sum = 0.0;
			else if ( sum > 1.0)
				sum = 1.0;

			
			float	veinSum;
			switch((int)veinPower) // this should be faster than a loop
			{
				case 1:
					veinSum = sum;
					break;
				case 2:
					veinSum = sum*sum;
					break;
				case 3:
					veinSum = sum*sum*sum;
					break;
				case 4:
					veinSum = sum*sum*sum*sum;
					break;
				case 5:
					veinSum = sum*sum*sum*sum*sum;
					break;
				case 6:
					veinSum = sum*sum*sum*sum*sum*sum;
					break;
				case 7:
					veinSum = sum*sum*sum*sum*sum*sum*sum;
					break;
				case 8:
					veinSum = sum*sum*sum*sum*sum*sum*sum*sum;
					break;
				default:
					veinSum = sum;
			}
			
			//---- do colors
			tssColor	tmpVein;
			tssColor	tmpBase1;
			tssColor	tmpBase2;
			tmpVein[0]	= vein_color[0]*veinMult;
			tmpVein[1]	= vein_color[1]*veinMult;
			tmpVein[2]	= vein_color[2]*veinMult;
			tmpBase1[0]	= base_color1[0]*base1Mult;
			tmpBase1[1]	= base_color1[1]*base1Mult;
			tmpBase1[2]	= base_color1[2]*base1Mult;
			tmpBase2[0]	= base_color2[0]*base2Mult;
			tmpBase2[1]	= base_color2[1]*base2Mult;
			tmpBase2[2]	= base_color2[2]*base2Mult;

			tssColor	baseResult;
			tssColorLinearInterpolate(baseResult, warp0, tmpBase2, tmpBase1);
			tssColorLinearInterpolate(result, veinSum, tmpVein, baseResult);

			tssColorAssign(surface->Co, result);
		}	
	}
}

// Helpers

COLORREF GetEvenColor()
{
	return RGB((BYTE)(vein_color[0] * 255.0f), (BYTE)(vein_color[1] * 255.0f), 
		(BYTE)(vein_color[2] * 255.0f));
}

COLORREF GetBaseColor1()
{
	return RGB((BYTE)(base_color1[0] * 255.0f), (BYTE)(base_color1[1] * 255.0f), 
		(BYTE)(base_color1[2] * 255.0f));
}

COLORREF GetBaseColor2()
{
	return RGB((BYTE)(base_color2[0] * 255.0f), (BYTE)(base_color2[1] * 255.0f), 
		(BYTE)(base_color2[2] * 255.0f));
}

void SetEvenColor(COLORREF color)
{
	vein_color[0] = ((float)GetRValue(color)) / 255.0f;
	vein_color[1] = ((float)GetGValue(color)) / 255.0f;
	vein_color[2] = ((float)GetBValue(color)) / 255.0f;

	tsxShaderUpdate(ShaderID);
}

void SetBaseColor1(COLORREF color)
{
	base_color1[0] = ((float)GetRValue(color)) / 255.0f;
	base_color1[1] = ((float)GetGValue(color)) / 255.0f;
	base_color1[2] = ((float)GetBValue(color)) / 255.0f;

	tsxShaderUpdate(ShaderID);
}
void SetBaseColor2(COLORREF color)
{
	base_color2[0] = ((float)GetRValue(color)) / 255.0f;
	base_color2[1] = ((float)GetGValue(color)) / 255.0f;
	base_color2[2] = ((float)GetBValue(color)) / 255.0f;

	tsxShaderUpdate(ShaderID);
}